#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_BloodUnitAntigen : BaseTest 
	{

		private DataTable _dtAntigen;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtAntigen = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitAntigen WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", true);
				
				this.RefreshData = false;
			}

		}

		[Test]
		public void GetBloodUnitAntigens_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtAntigen.Rows[0][TABLES.BloodUnitAntigen.BloodUnitGuid];

			DataTable dtTest = DAL.BloodUnitAntigen.GetBloodUnitAntigens(unitGuid.ToString(), this.TestDivisionCode);

			Assert.AreEqual(7, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitAntigen.BloodUnitGuid), TABLES.BloodUnitAntigen.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitAntigen.AntigenTypeId), TABLES.BloodUnitAntigen.AntigenTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.AntigenTypeName), TABLES.AntigenType.AntigenTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitAntigen.Positive), TABLES.BloodUnitAntigen.Positive);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitAntigen.RecordStatusCode), TABLES.BloodUnitAntigen.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitAntigen.DivisionCode), TABLES.BloodUnitAntigen.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitAntigen.RowVersion), TABLES.BloodUnitAntigen.RowVersion);

			Assert.AreEqual(dtTest.Rows[0][TABLES.BloodUnitAntigen.BloodUnitGuid].ToString(), this._dtAntigen.Rows[0][TABLES.BloodUnitAntigen.BloodUnitGuid].ToString() , "BloodUnitGuid");
		}

		[Test]
		public void GetBloodUnitAntigens_Fail()
		{
			DataTable dtTest = DAL.BloodUnitAntigen.GetBloodUnitAntigens(System.Guid.NewGuid().ToString(), this.TestDivisionCode);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetAllAntigensForBloodUnit_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtAntigen.Rows[0][TABLES.BloodUnitAntigen.BloodUnitGuid];

			DataTable dtTest = DAL.BloodUnitAntigen.GetAllAntigensForBloodUnit(unitGuid, this.TestDivisionCode);

			Assert.AreEqual(7, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitAntigen.BloodUnitGuid), TABLES.BloodUnitAntigen.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitAntigen.AntigenTypeId), TABLES.BloodUnitAntigen.AntigenTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.AntigenTypeName), TABLES.AntigenType.AntigenTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitAntigen.Positive), TABLES.BloodUnitAntigen.Positive);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitAntigen.RecordStatusCode), TABLES.BloodUnitAntigen.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitAntigen.DivisionCode), TABLES.BloodUnitAntigen.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitAntigen.RowVersion), TABLES.BloodUnitAntigen.RowVersion);

			Assert.AreEqual(dtTest.Rows[0][TABLES.BloodUnitAntigen.BloodUnitGuid].ToString(), this._dtAntigen.Rows[0][TABLES.BloodUnitAntigen.BloodUnitGuid].ToString(), "BloodUnitGuid");
		}

		[Test]
		public void GetAllAntigensForBloodUnit_Fail()
		{
			DataTable dtTest = DAL.BloodUnitAntigen.GetAllAntigensForBloodUnit(System.Guid.NewGuid(), this.TestDivisionCode);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}
		[Test]
		public void GetBloodUnitAntigenByGuidAndID_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtAntigen.Rows[0][TABLES.BloodUnitAntigen.BloodUnitGuid];
			DataTable dtTestBed = DAL.BloodUnitAntigen.GetAllAntigensForBloodUnit(unitGuid, this.TestDivisionCode);
			DataTable dtTest = DAL.BloodUnitAntigen.GetBloodUnitAntigenByGuidAndID((System.Guid) dtTestBed.Rows[0][TABLES.BloodUnitAntigen.BloodUnitGuid], (System.Int32) dtTestBed.Rows[0][TABLES.BloodUnitAntigen.AntigenTypeId]);
			Assert.AreEqual(dtTest.Rows[0][TABLES.BloodUnitAntigen.BloodUnitGuid].ToString(), this._dtAntigen.Rows[0][TABLES.BloodUnitAntigen.BloodUnitGuid].ToString(), "BloodUnitGuid");
		}

		[Test]
		public void GetBloodUnitAntigenByGuidAndID_Fail()
		{
			DataTable dtTest = DAL.BloodUnitAntigen.GetBloodUnitAntigenByGuidAndID(System.Guid.NewGuid(), 1000);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

	}
}
#endif
